/* ==UserStyle==
@name         WaniKani Elementary Dark
@namespace    github.com/openstyles/stylus
@version      3.0.1
@license      MIT
@description  Dark theme for the WaniKani domain
@author       Everesh
@homepageURL  https://github.com/Everesh/WaniKani-ElementaryDark
@supportURL   https://github.com/Everesh/WaniKani-ElementaryDark/issues
==/UserStyle== */
@-moz-document domain(www.wanikani.com) {
    :root {

        --USER-radical: #9182d4;
        --USER-kanji: #9f3e6a;
        --USER-vocab: #6d2aa6;
        --USER-correct: #319d4b;
        --USER-incorrect: #bb2f2c;


        --text-shadow-light: none;
        --text-shadow-dark: none;
        --color-icon: var(--USER-text, #eeeeee);
        --color-text: var(--USER-text, #eeeeee);
        --color-character-text: var(--USER-text, #eeeeee);
        --color-title-underline: var(--USER-text, #eeeeee);
        --color-link: var(--USER-text-grayed, #aaaaaa);
        --color-link-active: var(--USER-text, #eeeeee);
        --color-link-hover: var(--USER-text, #eeeeee);
        --color-radical: var(--USER-radical, #56638a);
        --color-radical-gradient: none;
        --color-kanji: var(--USER-kanji, #9c4644);
        --color-kanji-gradient: none;
        --color-vocabulary: var(--USER-vocab, #21cc71);
        --color-vocabulary-gradient: none;
        --color-burned: var(--USER-burned, #303030);
        --color-burned-gradient: none;
        --color-locked: var(--USER-surface-4, #535353);
        --color-locked-gradient: none;
        --color-new-badge-background: var(--USER-progress, #a97e42);
        --color-new-badge-text: var(--USER-text, #eeeeee);
        --color-subject-slide-navigation-background: var(--USER-surface-2, #282828);
        --color-subject-slide-navigation-text: var(--USER-text, #eeeeee);
        --color-subject-slide-navigation-button-hover: var(--USER-surface-3, #303030);
        --color-modal-background: var(--USER-surface-1, #151515);
        --color-lesson-modal-text: var(--USER-text, #eeeeee);
        --color-alert-info-background: var(--USER-alert, #9c4644);
        --color-alert-info-text: var(--USER-text, #eeeeee);
        --color-alert-info-border: var(--USER-alert, #9c4644);
        --color-alert-info-text-shadow: none;
        --color-alert-system-background: var(--USER-alert, #9c4644);
        --color-alert-system-text: var(--USER-text, #eeeeee);
        --color-button-danger-background: var(--USER-alert, #9c4644);
        --color-button-danger-hover-background: var(--USER-text, #eeeeee);
        --color-button-danger-active-background: var(--USER-text, #eeeeee);
        --color-button-danger-border: var(--USER-alert, #9c4644);
        --color-button-danger-hover-border: var(--USER-alert, #9c4644);
        --color-button-danger-active-border: var(--USER-alert, #9c4644);
        --color-button-danger-text: var(--USER-text, #eeeeee);
        --color-button-danger-hover-text: var(--USER-alert, #9c4644);
        --color-button-danger-active-text: var(--USER-alert, #9c4644);
        --color-button-danger-text-shadow: none;
        --color-button-danger-hover-text-shadow: none;
        --color-button-danger-active-text-shadow: none;
        --color-button-default-border: var(--USER-text, #eeeeee);
        --color-button-default-hover-border: var(--USER-text-grayed, #aaaaaa);
        --color-button-default-text: var(--USER-text, #eeeeee);
        --color-button-default-hover-text: var(--USER-text-grayed, #aaaaaa);
        --color-button-frameless-text: var(--USER-text-grayed, #aaaaaa);
        --color-button-frameless-hover-text: var(--USER-text, #eeeeee);
        --color-button-modal-primary-background: var(--USER-text, #eeeeee);
        --color-button-modal-primary-border: var(--USER-text, #eeeeee);
        --color-button-modal-primary-text: var(--USER-surface-1, #151515);
        --color-button-modal-primary-text-shadow: none;
        --color-button-modal-secondary-border: var(--USER-text, #eeeeee);
        --color-button-modal-secondary-text: var(--USER-text, #eeeeee);
        --color-button-quiz-background: var(--USER-surface-3, #303030);
        --color-button-quiz-text: var(--USER-text, #eeeeee);
        --color-button-lesson-picker-background: var(--USER-surface-3, #303030);
        --color-button-lesson-picker-border: var(--USER-surface-3, #303030);
        --color-button-lesson-picker-text: var(--USER-text, #eeeeee);
        --color-button-lesson-picker-box-shadow: none;
        --color-button-lesson-picker-text-shadow: none;
        --color-button-lesson-picker-hover-background: var(--USER-surface-3, #303030);
        --color-button-lesson-picker-hover-border: var(--USER-surface-3, #303030);
        --color-button-lesson-picker-hover-text: var(--USER-text, #eeeeee);
        --color-button-lesson-picker-hover-text-shadow: none;
        --color-button-lesson-picker-active-background: var(--USER-surface-3, #303030);
        --color-button-lesson-picker-active-border: var(--USER-surface-3, #303030);
        --color-button-lesson-picker-active-text: var(--USER-text, #eeeeee);
        --color-button-lesson-picker-active-text-shadow: none;
        --color-button-lesson-picker-disabled-background: var(--USER-text-grayed, #aaaaaa);
        --color-button-lesson-picker-disabled-hover-background: var(--USER-text-grayed, #aaaaaa);
        --color-button-lesson-picker-disabled-border: var(--USER-text-grayed, #aaaaaa);
        --color-button-lesson-picker-disabled-box-shadow: none;
        --color-button-lesson-picker-disabled-text: var(--USER-surface-2, #282828);
        --color-button-lesson-picker-disabled-text-shadow: none;
        --color-button-lesson-picker-count-background: var(--USER-text, #eeeeee);
        --color-button-lesson-picker-count-text: var(--USER-surface-3, #303030);
        --color-button-synonym-background: var(--USER-surface-3, #303030);
        --color-button-synonym-border: transparent;
        --color-button-synonym-text: var(--USER-text, #eeeeee);
        --color-button-synonym-text-shadow: none;
        --color-button-synonym-hover-background: var(--USER-surface-inv, #bababa);
        --color-button-synonym-hover-border: transparent;
        --color-button-synonym-hover-text: var(--USER-text-inv, #151515);
        --color-button-synonym-hover-text-shadow: none;
        --color-button-synonym-active-background: var(--USER-surface-inv, #bababa);
        --color-button-synonym-active-border: transparent;
        --color-button-synonym-active-text: var(--USER-text-inv, #151515);
        --color-button-synonym-active-text-shadow: none;
        --color-code-text: var(--USER-alert, #9c4644);
        --color-code-background: var(--USER-text, #eeeeee);
        --color-code-border: var(--USER-alert, #9c4644);
        --color-input-text: var(--USER-text, #eeeeee);
        --color-input-background: var(--USER-surface-2, #282828);
        --color-input-border: var(--USER-surface-2, #282828);
        --color-input-focus-border: var(--USER-surface-3, #303030);
        --color-lesson-and-review-count-background: var(--USER-lesson, #9c4644);
        --color-lesson-and-review-count-zero-background: var(--USER-surface-3, #303030);
        --color-lesson-and-review-count-text: var(--USER-text, #eeeeee);
        --color-lesson-and-review-count-text-shadow: none;
        --color-reviews-dashboard-background: var(--USER-review, #56638a);
        --color-todays-lessons-background: var(--USER-lesson, #9c4644);
        --color-todays-lessons-completed-background: var(--USER-surface-2, #282828);
        --color-todays-lessons-loading-background: var(--USER-surface-2, #282828);
        --color-todays-lessons-text: var(--USER-text, #eeeeee);
        --color-placeholder-background-stop-1: var(--USER-surface-3, #303030);
        --color-placeholder-background-stop-2: var(--USER-surface-4, #535353);
        --color-level-progress-bar-background: var(--USER-surface-3, #303030);
        --color-level-progress-bar-text: var(--USER-text, #eeeeee);
        --color-level-progress-bar-progress: var(--USER-progress, #a97e42);
        --color-level-progress-bar-progress-text: var(--USER-text, #eeeeee);
        --color-quiz-input-background: var(--USER-surface-2, #282828);
        --color-quiz-input-focus: var(--USER-surface-3, #303030);
        --color-quiz-incorrect-background: var(--USER-incorrect, #9c4644);
        --color-quiz-incorrect-text-color: var(--USER-text, #eeeeee);
        --color-quiz-incorrect-text-shadow: none;
        --color-quiz-correct-background: var(--USER-correct, #58896f);
        --color-quiz-correct-text-color: var(--USER-text, #eeeeee);
        --color-quiz-correct-text-shadow: none;
        --color-quiz-srs-correct-background: var(--USER-correct, #58896f);
        --color-quiz-srs-correct-text-color: var(--USER-text, #eeeeee);
        --color-quiz-srs-correct-text-shadow: none;
        --color-quiz-srs-incorrect-background: var(--USER-incorrect, #9c4644);
        --color-quiz-srs-incorrect-text-color: var(--USER-text, #eeeeee);
        --color-quiz-srs-incorrect-text-shadow: none;
        --color-srs-progress-text: var(--USER-text, #eeeeee);
        --color-srs-progress-header-divider: var(--USER-text, #eeeeee);
        --color-srs-progress-apprentice: var(--USER-apprentice, #47454e);
        --color-srs-progress-burned: var(--USER-burned, #303030);
        --color-srs-progress-enlightened: var(--USER-enlightened, #934c3f);
        --color-srs-progress-guru: var(--USER-guru, #605c74);
        --color-srs-progress-master: var(--USER-master, #9A815d);
        --color-srs-progress-subject-type-background: rgba(0, 0, 0, 0.1);
        --color-subject-srs-progress-stage-background: var(--USER-text, #eeeeee);
        --color-subject-srs-progress-stage-complete-background: var(--USER-progress, #a97e42);
        --color-wk-panel-background: var(--USER-surface-2, #282828);
        --color-wk-panel-content-background: var(--USER-surface-3, #303030);
        --color-wk-panel-content-title-underline: var(--USER-text, #eeeeee);
        --color-recent-mistakes-intro-divider: var(--USER-text, #eeeeee);
        --color-review-forecast-divider: var(--USER-text, #eeeeee);
        --color-review-forecast-increase-sign: var(--USER-text, #eeeeee);
        --color-review-forecast-bar: var(--USER-brand, #9c4644);
        --color-billing-plan-background: var(--USER-surface-3, #303030);
        --color-billing-plan-border: var(--USER-text-hl, #c29354);
        --color-billing-plan-title-background: var(--USER-text-hl, #c29354);
        --color-billing-plan-title-text: var(--USER-surface-3, #303030);
        --color-billing-receipt-background-hover: var(--USER-surface-3, #303030);
        --color-billing-activation-error: var(--USER-alert, #9c4644);
        --color-lesson-picker-footer-background: var(--USER-surface-2, #282828);
        --color-lesson-picker-footer-border: 1px solid var(--USER-surface-3, #303030);
        --color-lesson-picker-footer-shadow-color: transparent;
        --color-lesson-picker-footer-shadow: none;
        --color-subject-list-separator: var(--USER-text, #eeeeee);
        --color-character-grid-header-background: var(--USER-surface-3, #303030);
        --color-character-grid-header-text: var(--USER-text, #eeeeee);
        --color-count_bubble-background: var(--USER-text, #eeeeee);
        --color-authentication-footer-divider: var(--USER-text, #eeeeee);
        --color-text-highlight-default-text: var(--USER-text, #eeeeee);
        --color-text-highlight-radical-background: var(--USER-radical, #56638a);
        --color-text-highlight-radical-text: var(--USER-text, #eeeeee);
        --color-text-highlight-kanji-background: var(--USER-kanji, #9c4644);
        --color-text-highlight-kanji-text: var(--USER-text, #eeeeee);
        --color-text-highlight-vocabulary-background: var(--USER-vocab, #58896f);
        --color-text-highlight-vocabulary-text: var(--USER-text, #eeeeee);
        --color-text-highlight-meaning-background: var(--USER-text-inv, #151515);
        --color-text-highlight-reading-background: var(--USER-text-inv, #151515);
        --color-text-highlight-radical-gradient: none;
        --color-text-highlight-kanji-gradient: none;
        --color-text-highlight-vocabulary-gradient: none;
        --color-text-highlight-meaning-gradient: none;
        --color-text-highlight-reading-gradient: none;
        --text-highlight-text-shadow: none;
        --text-highlight-box-shadow: none;
        --color-nav-header-text: var(--USER-text, #eeeeee);
        --color-nav-header-text-shadow: none;
        --color-nav-item-background: var(--USER-surface-3, #303030);
        --color-nav-item-text: var(--USER-text, #eeeeee);
        --color-nav-item-text-shadow: none;
        --color-nav-item-highlight-background: var(--USER-surface-4, #535353);
        --color-nav-item-highlight-text: var(--USER-text, #eeeeee);
        --color-nav-item-highlight-text-shadow: none;
        --color-setting-divider: var(--USER-text, #eeeeee);
        --color-progress-chart-bar-background: var(--USER-surface-3, #303030);
        --color-progress-chart-bar: var(--USER-progress, #a97e42);
        --color-progress-chart-bar-gradient: none;
        --color-progress-chart-label-text: var(--USER-text, #eeeeee);
        --color-progress-chart-label-text-shadow: none;
        --color-progress-chart-metric-text: var(--USER-text, #eeeeee);
        --color-progress-chart-metric-count: var(--USER-surface-1, #151515);
        --color-progress-chart-metric-count-background: var(--USER-text, #eeeeee);
        --color-progress-chart-metric-count-shadow: none;
        --color-public-profile-avatar-border: var(--USER-surface-2, #282828);
        --color-public-profile-info-background: var(--USER-surface-2, #282828);
        --color-public-profile-info-text: var(--USER-text, #eeeeee);
        --color-public-profile-info-text-emphasis: var(--USER-text-hl, #c29354);
        --color-dashboard-list-empty-icon: var(--USER-text, #eeeeee);
        --color-community-banner-background: var(--USER-surface-2, #282828);
        --color-community-banner-border: transparent;
        --color-community-banner-text: var(--USER-text, #eeeeee);
        --color-button-secondary-text: var(--USER-text, #fff);
        --color-widget-background: var(--USER-background, #303030);
        --color-widget-primary-text: var(--USER-text, #eeeeee);
        --color-item-spread-row-background: var(--USER-background, #535252);
        --color-extra-study-button-background: var(--USER-background, #535252);
        --color-extra-study-button-text: var(--USER-text, #eeeeee);
        --color-button-secondary-background: var(--USER-button-background, #1C1C1C);
        --color-count-bubble-text: var(--USER-text-w, #151515);
        --color-extra-study-button-remaining-text: var(--USER-text-r, #b7b2b2);
        --color-subject-character-grid-item-background: #282828;
        --color-subject-hint-background: #282828;

        /*--color-button-background: var(--USER-button, #151515);*/
    }

    #turbo-body,
    .site-content-container,
    .site-footer-container,
    .lesson-container {
        background-color: var(--USER-surface-1, #151515);
        background-image: none;
    }

    a.item-spread-table-row > div:nth-child(3) {
        color: #000;
    }
    
    .reviews-widget--complete, .todays-lessons-widget--complete {
        background: #282828;
    }

    .review-forecast-widget__header {
        background-color: #282828;
    }

    .extra-study-multi-button-widget__button--disabled {
        background: #151515;
    }

    .global-header {
        background: var(--USER-surface-2, #282828);
        border-bottom-color: var(--USER-surface-4, #535353);
    }
    .global-header .logo {
        filter: var(--USER-logo-filter, invert(1) saturate(0) brightness(1.6));
    }
    .global-header .sitemap__section-header {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .global-header .lesson-and-review-count :first-child * {
        --color-lesson-and-review-count-background: var(--USER-lesson, #9c4644);
    }
    .global-header .lesson-and-review-count :nth-child(2) * {
        --color-lesson-and-review-count-background: var(--USER-review, #56638a);
    }
    .global-header .sitemap__expandable-chunk--levels::before {
        background-color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__expandable-chunk--levels {
        background-color: var(--USER-surface-3, #303030);
    }
    .global-header .sitemap__expandable-chunk--levels .sitemap__group-header {
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .global-header .sitemap__expandable-chunk--levels .sitemap__pages--levels .sitemap__page a {
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-surface-4, #535353);
    }
    .global-header .sitemap__expandable-chunk--levels .sitemap__pages--levels .sitemap__page a:hover {
        color: var(--USER-surface-3, #303030);
        background-color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__expandable-chunk--levels .sitemap__page--current-level a {
        border-color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__expandable-chunk--radicals,
    .global-header .sitemap__expandable-chunk--kanji,
    .global-header .sitemap__expandable-chunk--vocabulary,
    .global-header .sitemap__expandable-chunk {
        background-color: var(--USER-surface-3, #303030);
        color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__page--subject a,
    .global-header .sitemap__page-subtitle {
        color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__page a {
        color: var(--USER-text, #eeeeee);
    }
    .global-header #sitemap__account .sitemap__page a:hover,
    .global-header #sitemap__account .sitemap__page a:focus,
    .global-header #sitemap__help .sitemap__page--subject a:hover,
    .global-header #sitemap__help .sitemap__page--subject a:focus {
        background-color: var(--USER-text, #eeeeee);
        color: var(--USER-surface-3, #303030);
    }
    .global-header .sitemap__section-header:hover,
    .global-header .sitemap__section-header:focus,
    .global-header .search-button:hover,
    .global-header .search-button:focus {
        border-color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__section-header--subsection {
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .global-header .sitemap__expandable-chunk:before {
        background-color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap__section--open .sitemap__section-header--radicals,
    .global-header .sitemap__section-header--radicals:hover,
    .global-header .sitemap__section-header--radicals:focus {
        border-color: var(--USER-radical, #56638a);
    }
    .global-header .sitemap__expandable-chunk--radicals:before {
        background-color: var(--USER-radical, #56638a);
    }
    .global-header .sitemap__pages--radical .sitemap__page--subject {
        border-color: var(--USER-radical, #56638a);
    }
    .global-header .sitemap__pages--radical .sitemap__page--subject a:hover {
        background-color: var(--USER-radical, #56638a);
    }
    .global-header .sitemap__section--open .sitemap__section-header--kanji,
    .global-header .sitemap__section-header--kanji:hover,
    .global-header .sitemap__section-header--kanji:focus {
        border-color: var(--USER-kanji, #9c4644);
    }
    .global-header .sitemap__expandable-chunk--kanji:before {
        background-color: var(--USER-kanji, #9c4644);
    }
    .global-header .sitemap__pages--kanji .sitemap__page--subject {
        border-color: var(--USER-kanji, #9c4644);
    }
    .global-header .sitemap__pages--kanji .sitemap__page--subject a:hover {
        background-color: var(--USER-kanji, #9c4644);
    }
    .global-header .sitemap__section--open .sitemap__section-header--vocabulary,
    .global-header .sitemap__section-header--vocabulary:hover,
    .global-header .sitemap__section-header--vocabulary:focus {
        border-color: var(--USER-vocab, #58896f);
    }
    .global-header .sitemap__expandable-chunk--vocabulary:before {
        background-color: var(--USER-vocab, #58896f);
    }
    .global-header .sitemap__pages--vocabulary .sitemap__page--subject {
        border-color: var(--USER-vocab, #58896f);
    }
    .global-header .sitemap__pages--vocabulary .sitemap__page--subject a:hover {
        background-color: var(--USER-vocab, #58896f);
    }
    .global-header .navigation__toggle .navigation__toggle-icon,
    .global-header .navigation__toggle .navigation__toggle-icon::before,
    .global-header .navigation__toggle .navigation__toggle-icon::after {
        background: var(--USER-text, #eeeeee);
        border-color: var(--USER-text, #eeeeee);
    }
    .global-header .navigation--open .navigation__toggle {
        background-color: var(--USER-surface-3, #303030);
    }
    .global-header .navigation--open .navigation__toggle .navigation__toggle-icon {
        background: transparent;
        border-color: transparent;
    }
    .global-header .navigation--open .navigation__toggle .navigation__toggle-icon::before,
    .global-header .navigation--open .navigation__toggle .navigation__toggle-icon::after {
        background: var(--USER-text, #eeeeee);
        border-color: var(--USER-text, #eeeeee);
    }
    .global-header .navigation--open .sitemap {
        box-shadow: none;
        background-color: var(--USER-surface-2, #282828);
    }
    .global-header .navigation--open .sitemap .sitemap__section-header::before {
        border-color: var(--USER-text, #eeeeee);
    }
    .global-header .navigation--open .sitemap .sitemap--divider {
        border-color: var(--USER-text, #eeeeee);
    }
    .global-header .sitemap {
        box-shadow: none;
        background-color: var(--USER-surface-2, #282828);
    }

    .search--open .search__query {
        background-color: var(--USER-surface-3, #303030);
        color: var(--USER-text, #eeeeee);
        border-color: var(--USER-text, #eeeeee);
    }
    .search--open .search__query::placeholder {
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .search--open .search__button {
        color: var(--USER-surface-1, #151515);
        background: var(--USER-text, #eeeeee);
    }
    .search--open .search__button:hover,
    .search--open .search__button:focus {
        background: var(--USER-text-grayed, #aaaaaa);
    }

    .wk-button--default:hover {
        --color-icon: var(--USER-text-grayed, #aaaaaa);
    }

    turbo-frame[data-show-loading=true]:not([complete]):after {
        filter: var(--USER-loading-filter, grayscale(100%) invert(1) hue-rotate(180deg) contrast(0.68));
    }

    .footer__item--copyright {
        filter: invert(1);
        background-color: var(--USER-kanji, #9c4644);
    }

    .reading-with-audio__audio-item[playing=true] .wk-icon--sound_off {
        display: inline-block;
        --color-icon: var(--USER-text-grayed, #aaaaaa);
    }

    /*  Invert highlight fg, bg
   *    WaniKani uses same --color for text of all highlights
   *    This stylesheets require inverted text color for meaning/reading hl
   */
    .highlight-reading,
    .highlight-reading > span,
    .reading-highlight,
    .reading-highlight > span,
    .bg-\[\#f1d6ff\],
    .bg-\[\#f8d8ef\],
    .bg-\[\#d6f1ff\] {
        background-color: var(--USER-surface-inv, #bababa);
        color: var(--USER-surface-2, #282828);
        font-weight: bold;
    }

    :root {
        --ED-surface-1: var(--USER-surface-1, #151515);
        --ED-surface-2: var(--USER-surface-2, #282828);
        --ED-surface-3: var(--USER-surface-3, #303030);
        --ED-surface-4: var(--USER-surface-4, #535353);
        --ED-surface-inv: var(--USER-surface-inv, #bababa);
        --ED-text: var(--USER-text, #eeeeee);
        --ED-text-inv: var(--USER-text-inv, #151515);
        --ED-text-hl: var(--USER-text-hl, #c29354);
        --ED-text-grayed: var(--USER-text-grayed, #aaaaaa);
        --ED-radical: var(--USER-radical, #56638a);
        --ED-kanji: var(--USER-kanji, #9c4644);
        --ED-vocab: var(--USER-vocab, #58896f);
        --ED-apprentice: var(--USER-apprentice, #47454e);
        --ED-guru: var(--USER-guru, #605c74);
        --ED-master: var(--USER-master, #9A815d);
        --ED-enlightened: var(--USER-enlightened, #934c3f);
        --ED-burned: var(--USER-burned, #303030);
        --ED-lesson: var(--USER-lesson, #9c4644);
        --ED-review: var(--USER-review, #56638a);
        --ED-correct: var(--USER-correct, #58896f);
        --ED-incorrect: var(--USER-incorrect, #9c4644);
        --ED-brand: var(--USER-brand, #9c4644);
        --ED-progress: var(--USER-progress, #a97e42);
        --ED-alert: var(--USER-alert, #9c4644);
        --ED-logo-filter: var(--USER-logo-filter, invert(1) saturate(0) brightness(1.6));
        --ED-extra-study-filter: var(--USER-extra-study-filter, invert(0.81));
        --ED-locked-item-filter: var(--USER-locked-item-filter, brightness(70%));
        --ED-kotoba-odd-row-filter: var(--USER-kotoba-odd-row-filter, brightness(0.95));
        --ED-footer-filter: var(--USER-footer-filter, invert(1));
        --ED-loading-filter: var(--USER-loading-filter, grayscale(100%) invert(1) hue-rotate(180deg) contrast(0.68));
    }


    .dashboard__lessons-and-reviews .todays-lessons {
        --color-icon: var(--USER-lesson, #9c4644);
    }
    .dashboard__lessons-and-reviews .todays-lessons .wk-button--modal-primary:hover {
        --color-icon: var(--USER-text, #eeeeee);
        background-color: var(--USER-lesson, #9c4644);
        color: var(--USER-text, #eeeeee);
    }
    .dashboard__lessons-and-reviews .todays-lessons .wk-button--modal-secondary {
        --color-icon: var(--USER-text, #eeeeee);
    }
    .dashboard__lessons-and-reviews .todays-lessons .wk-button--modal-secondary:hover {
        --color-icon: var(--USER-lesson, #9c4644);
        background-color: var(--USER-text, #eeeeee);
        color: var(--USER-lesson, #9c4644);
    }
    .dashboard__lessons-and-reviews .reviews-dashboard {
        --color-icon: var(--USER-review, #56638a);
    }
    .dashboard__lessons-and-reviews .reviews-dashboard .wk-button--modal-primary:hover {
        --color-icon: var(--USER-text, #eeeeee);
        background-color: var(--USER-review, #56638a);
        color: var(--USER-text, #eeeeee);
    }

    .extra-study__image {
        filter: var(--USER-extra-study-filter, invert(0.81));
    }

    .srs-progress__subject-type-count {
        color: var(--USER-text, #eeeeee);
    }

    .subject-character--small .subject-character__characters {
        box-shadow: none;
        color: var(--USER-text, #eeeeee);
    }

    .dashboard-lists li:last-child a {
        border-radius: 0 0 0.3em 0.3em;
    }

    .dashboard-lists li:first-child a {
        border-radius: 0.3em 0.3em 0 0;
    }

    .dashboard-lists li:nth-child(odd) a {
        filter: var(--USER-kotoba-odd-row-filter, brightness(0.95));
    }

    .subject-character--grid:after {
        border: none;
    }

    .footer--illustrated {
        filter: var(--USER-footer-filter, invert(1));
    }

    .lesson-picker .page-header__title {
        text-shadow: none;
    }
    .lesson-picker .lesson-picker__link {
        color: var(--color-link);
    }
    .lesson-picker .lesson-picker__link:hover {
        color: var(--color-link-hover);
    }
    .lesson-picker .lesson-picker__link:active {
        color: var(--color-link-actiove);
    }
    .lesson-picker .lesson-picker__section-toggle:hover,
    .lesson-picker .lesson-picker__section-toggle-all:hover,
    .lesson-picker .wk-panel__header .lesson-picker__section-toggle:hover {
        color: var(--color-link-hover);
    }
    .lesson-picker .lesson-picker__section-toggle:active,
    .lesson-picker .lesson-picker__section-toggle-all:active,
    .lesson-picker .wk-panel__header .lesson-picker__section-toggle:active {
        color: var(--color-link-actiove);
    }
    .lesson-picker .lesson-picker__footer .lesson-picker__button:hover {
        filter: brightness(0.9);
    }

    .character-header {
        background-image: none;
    }
    .character-header .character-header__characters {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .character-header .character-header__menu {
        color: var(--USER-text, #eeeeee);
    }

    .character-header--radical {
        background-color: var(--USER-radical, #56638a);
    }

    .character-header--kanji {
        background-color: var(--USER-kanji, #9c4644);
    }

    .character-header--vocabulary {
        background-color: var(--USER-vocab, #58896f);
    }

    .quiz-input__question-type-container[data-question-type=meaning] {
        color: var(--USER-text-inv, #151515);
        background: var(--USER-surface-inv, #bababa);
        text-shadow: none;
        background-image: none;
        border: none;
    }
    .quiz-input__question-type-container[data-question-type=reading] {
        color: var(--USER-text, #eeeeee);
        background: var(--USER-surface-2, #282828);
        text-shadow: none;
        background-image: none;
        border: none;
    }

    .quiz-progress__bar {
        background-color: var(--USER-progress, #a97e42);
    }

    .quiz-input__input {
        text-shadow: none;
        box-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .quiz-input__input::placeholder {
        color: var(--USER-text-grayed, #aaaaaa);
    }

    .additional-content__item {
        box-shadow: none;
        background-color: var(--USER-surface-2, #282828);
        color: var(--USER-text, #eeeeee);
        border-color: var(--USER-surface-2, #282828);
    }

    .additional-content__item--open::after {
        border-color: rgba(0, 0, 0, 0) rgba(0, 0, 0, 0) var(--USER-surface-3, #303030) rgba(0, 0, 0, 0);
    }

    .additional-content__content {
        background-color: var(--USER-surface-2, #282828);
        box-shadow: none;
        border-color: var(--USER-surface-3, #303030);
    }
    .additional-content__content .subject-info:not([complete])::after,
    .additional-content__content .last-items:not([complete])::after,
    .additional-content__content .kana-chart:not([complete])::after {
        filter: var(--USER-loading-filter, grayscale(100%) invert(1) hue-rotate(180deg) contrast(0.68));
    }
    .additional-content__content .subject-character--burned:not(.subject-character--grid) .subject-character__characters,
    .additional-content__content .subject-character--grid.subject-character--burned,
    .additional-content__content .subject-character--small-with-meaning .subject-character__characters {
        box-shadow: none;
    }
    .additional-content__content .subject-character--grid.subject-character--burned .subject-character__characters,
    .additional-content__content .subject-character--grid.subject-character--burned .subject-character__info {
        opacity: 1;
    }
    .additional-content__content .subject-hint {
        --color-icon: var(--USER-text-inv, #151515);
        color: var(--USER-text-inv, #151515);
        background-color: var(--USER-surface-inv, #bababa);
        text-shadow: none;
        border-radius: 5px;
    }
    .additional-content__content .subject-hint .subject-hint__title {
        text-shadow: none;
        color: var(--USER-text-inv, #151515);
    }
    .additional-content__content .subject-section__meanings {
        align-items: center;
        margin-bottom: 8px;
        margin-top: 8px;
    }
    .additional-content__content .subject-section__meanings-title {
        color: var(--USER-text, #eeeeee);
        font-size: 1rem;
    }
    .additional-content__content .subject-section__meanings-items,
    .additional-content__content .subject-readings {
        color: var(--USER-text-hl, #c29354);
        font-weight: bold;
        font-size: 1.5rem;
    }
    .additional-content__content .subject-readings__reading-title,
    .additional-content__content .subject-readings {
        text-shadow: none;
    }
    .additional-content__content .subject-readings__reading-title {
        color: var(--USER-text, #eeeeee);
    }
    .additional-content__content .subject-section__title,
    .additional-content__content .subject-section__subtitle,
    .additional-content__content .subject-section__text {
        text-shadow: none;
        border-color: var(--USER-text, #eeeeee);
    }
    .additional-content__content .user-note__link {
        text-shadow: none;
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .additional-content__content .user-note__fields {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
    }
    .additional-content__content .user-note__fields .user-note__input {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .additional-content__content .user-note__fields .user-note__character-count {
        color: var(--USER-text, #eeeeee);
    }
    .additional-content__content .user-note__fields .user-note__button {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .additional-content__content .subject-readings-with-audio {
        text-shadow: none;
    }
    .additional-content__content .subject-readings-with-audio .reading-with-audio__reading {
        font-size: 2rem;
        font-weight: bold;
        color: var(--USER-text-hl, #c29354);
    }
    .additional-content__content .subject-collocations__title,
    .additional-content__content .subject-collocations {
        text-shadow: none;
    }
    .additional-content__content .subject-collocations__patterns::after {
        box-shadow: 0 0 1px var(--USER-text-grayed, #aaaaaa);
    }
    .additional-content__content .subject-collocations__pattern-name {
        background-color: var(--USER-surface-inv, #bababa);
        color: var(--USER-surface-2, #282828);
        filter: brightness(0.6);
        text-shadow: none;
    }
    .additional-content__content .subject-collocations__pattern-name[aria-selected=true] {
        filter: none;
    }
    .additional-content__content .subject-collocations__pattern-name[aria-selected=true]::after {
        background-color: var(--USER-surface-2, #282828);
        background-image: none;
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
    }
    .additional-content__content .subject-character-grid--single-column li:nth-child(odd) {
        filter: var(--USER-kotoba-odd-row-filter, brightness(0.95));
    }
    .additional-content__content .subject-character-grid--single-column li:first-child a {
        border-radius: 0.3em 0.3em 0 0;
    }
    .additional-content__content .subject-character-grid--single-column li:last-child a {
        border-radius: 0 0 0.3em 0.3em;
    }
    .additional-content__content .subject-character--grid.subject-character--locked {
        background-image: none;
        filter: var(--USER-locked-item-filter, brightness(70%));
    }
    .additional-content__content .last-item {
        box-shadow: none;
        background-color: var(--USER-surface-3, #303030);
        color: var(--USER-text, #eeeeee);
        border-radius: 0.3em 0.3em 0.3em 0.3em;
    }
    .additional-content__content .last-item .last-item__characters--radical {
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-radical, #56638a);
        text-shadow: none;
    }
    .additional-content__content .last-item .last-item__characters--kanji {
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-kanji, #9c4644);
        text-shadow: none;
    }
    .additional-content__content .last-item .last-item__characters--vocabulary {
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-vocab, #58896f);
        text-shadow: none;
    }
    .additional-content__content .last-item .last-item__label {
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .additional-content__content .last-item .last-item__value {
        color: var(--USER-text, #eeeeee);
    }
    .additional-content__content .kana-chart__tab {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
        border-bottom: 1px solid var(--USER-text, #eeeeee);
        border-radius: 6px 6px 0 0;
    }
    .additional-content__content .kana-chart__tab.kana-chart__tab--selected {
        border: 1px solid var(--USER-text, #eeeeee);
        border-bottom: none;
    }
    .additional-content__content .kana-chart__tab:hover {
        background-color: var(--USER-surface-inv, #bababa);
        color: var(--USER-text-inv, #151515);
    }
    .additional-content__content .kana-chart__backspace {
        background-color: var(--USER-surface-inv, #bababa);
        color: var(--USER-text-inv, #151515);
    }
    .additional-content__content .kana-chart__backspace .kana-chart__backspace-text {
        text-shadow: none;
    }
    .additional-content__content .kana-chart__backspace:hover {
        background-color: var(--USER-text-grayed, #aaaaaa);
    }
    .additional-content__content .kana-chart__character {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
    }
    .additional-content__content .kana-chart__character:hover {
        background-color: var(--USER-surface-4, #535353);
    }
    .additional-content__content .kana-chart__character .kana-chart__character-romaji {
        color: var(--USER-text-grayed, #aaaaaa);
    }

    .user-synonyms__form_container .user-synonyms__synonym-button:hover .wk-icon,
    .user-synonyms__form_container .user-synonyms__synonym-button:active .wk-icon {
        --color-icon: var(--USER-text-inv, #151515);
    }

    .answer-exception,
    .quiz-input__exception {
        text-shadow: none;
        box-shadow: none;
        background-color: var(--USER-surface-3, #303030);
        color: var(--USER-text, #eeeeee);
    }
    .answer-exception:before,
    .quiz-input__exception:before {
        border-color: rgba(0, 0, 0, 0) rgba(0, 0, 0, 0) var(--USER-surface-3, #303030) rgba(0, 0, 0, 0);
    }

    .hotkeys-menu {
        color: var(--USER-text, #eeeeee);
        text-shadow: none;
        background-color: var(--USER-surface-3, #303030);
        border-radius: 0.3em 0.3em 0 0;
    }
    .hotkeys-menu.hotkeys-menu--open {
        border: 1px solid var(--USER-surface-1, #151515);
        border-bottom: none;
    }
    .hotkeys-menu .hotkeys-menu__header {
        color: var(--USER-text, #eeeeee);
        border-radius: 0.3em 0.3em 0 0;
        background-color: var(--USER-surface-2, #282828);
    }
    .hotkeys-menu .hotkeys-menu__key {
        background-color: var(--USER-surface-4, #535353);
    }

    .chat-button {
        background-color: var(--USER-surface-2, #282828);
    }

    #user_synonyms {
        flex-direction: row;
        align-items: center;
    }
    #user_synonyms ul {
        color: var(--USER-text-hl, #c29354);
        font-weight: bold;
        font-size: 1.5em;
    }

    .character-header--radical .character-header__meaning,
    .character-header--kanji .character-header__meaning,
    .character-header--vocabulary .character-header__meaning {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }

    .subject-slides__navigation-link[aria-selected=true]::after {
        border-color: rgba(0, 0, 0, 0) rgba(0, 0, 0, 0) var(--USER-surface-3, #303030) rgba(0, 0, 0, 0);
    }

    .subject-slide {
        background-color: var(--USER-surface-2, #282828);
        border-color: var(--USER-surface-3, #303030);
        box-shadow: none;
    }
    .subject-slide .user-note__link {
        text-shadow: none;
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .subject-slide .user-note__fields {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
    }
    .subject-slide .user-note__fields .user-note__input {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .subject-slide .user-note__fields .user-note__character-count {
        color: var(--USER-text, #eeeeee);
    }
    .subject-slide .user-note__fields .user-note__button {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .subject-slide .subject-section__title {
        text-shadow: none;
        border-color: var(--USER-text, #eeeeee);
    }
    .subject-slide .subject-readings-with-audio {
        text-shadow: none;
    }
    .subject-slide .subject-collocations__title,
    .subject-slide .subject-collocations {
        text-shadow: none;
    }
    .subject-slide .subject-collocations__patterns::after {
        box-shadow: 0 0 1px var(--USER-text-grayed, #aaaaaa);
    }
    .subject-slide .subject-collocations__pattern-name {
        background-color: var(--USER-surface-inv, #bababa);
        color: var(--USER-surface-2, #282828);
        filter: brightness(0.6);
    }
    .subject-slide .subject-collocations__pattern-name[aria-selected=true] {
        filter: none;
    }
    .subject-slide .subject-collocations__pattern-name[aria-selected=true]::after {
        background-color: var(--USER-surface-2, #282828);
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        background-image: none;
    }
    .subject-slide .character--small-with-meaning .subject-character__characters,
    .subject-slide .subject-character--small-with-meaning .subject-character__characters {
        box-shadow: none;
    }
    .subject-slide .wk-hint {
        --color-icon: var(--USER-text-inv, #151515);
        color: var(--USER-text-inv, #151515);
        background-color: var(--USER-surface-inv, #bababa);
        text-shadow: none;
        border-radius: 5px;
    }
    .subject-slide .wk-hint .wk-hint__title {
        text-shadow: none;
        color: var(--USER-text-inv, #151515);
    }
    .subject-slide .reading-with-audio__reading,
    .subject-slide .subject-slide__aside .subject-section:first-of-type p {
        color: var(--USER-text-hl, #c29354);
        font-size: 1.5rem;
        font-weight: bold;
    }
    .subject-slide .reading-with-audio__reading[lang=ja],
    .subject-slide .subject-slide__aside .subject-section:first-of-type p[lang=ja] {
        font-size: 2rem;
    }

    .subject-character--tiny .subject-character__characters {
        box-shadow: none;
    }

    .wk-button--quiz {
        box-shadow: none;
    }
    .wk-button--quiz:hover {
        filter: brightness(0.9);
    }

    .lesson-modal .wk-button--modal-primary {
        --color-icon: var(--USER-surface-1, #151515);
    }
    .lesson-modal .wk-button--modal-primary:hover,
    .lesson-modal .wk-button--modal-primary:focus,
    .lesson-modal .wk-button--modal-primary:active {
        --color-icon: var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-surface-1, #151515);
    }

    .page-header__title {
        text-shadow: none;
    }

    .page-header__title-subtext {
        color: var(--USER-text-grayed, #aaaaaa);
    }

    .subject-legend {
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
        border-radius: 5px;
    }
    .subject-legend .subject-legend__title {
        color: var(--USER-text, #eeeeee);
    }
    .subject-legend .subject-legend__item-badge--recently-unlocked {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-progress, #a97e42);
    }
    .subject-legend .subject-legend__item-badge--all {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-brand, #9c4644);
    }
    .subject-legend .subject-legend__item-badge--radicals {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-radical, #56638a);
    }
    .subject-legend .subject-legend__item-badge--kanji {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-kanji, #9c4644);
    }
    .subject-legend .subject-legend__item-badge--vocabulary {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-vocab, #58896f);
    }
    .subject-legend .subject-legend__item-badge--locked {
        background-image: none;
        filter: var(--USER-locked-item-filter, brightness(70%));
    }
    .subject-legend .subject-legend__item-badge--burned {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
        color: var(--USER-text, #eeeeee);
        background-color: var(--USER-burned, #303030);
    }

    .character-grid__header {
        border-radius: 5px 5px 0 0;
    }

    .subject-character--grid.subject-character--burned {
        box-shadow: none;
    }

    .subject-character--grid.subject-character--locked {
        background-image: none;
        filter: brightness(0.7);
    }

    .subject-character-grid__items .subject-character-grid__item:nth-child(odd) {
        filter: var(--USER-kotoba-odd-row-filter, brightness(0.95));
    }

    .site-content-container .container:has(.character-grid) {
        background-color: var(--USER-surface-2, #282828);
        border-radius: 5px;
        padding: 0 1.5em;
    }
    .site-content-container .container:has(.character-grid) > :first-child,
    .site-content-container .container:has(.character-grid) > .page-header {
        padding-top: 1.5em;
    }
    .site-content-container .container:has(.character-grid) > :last-child {
        padding-bottom: 1.5em;
    }
    .site-content-container .container:has(.character-grid) .subject-character-grid--single-column li:last-child a {
        border-radius: 0 0 5px 5px;
    }

    .site-content-container .container:has(.page-header__icon--level) {
        background-color: var(--USER-surface-2, #282828);
        border-radius: 5px;
        padding: 0 1.5em;
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon,
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--radical,
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--kanji,
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--vocabulary {
        color: var(--USER-text, #eeeeee);
        background-image: none;
        box-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon:hover,
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--radical:hover,
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--kanji:hover,
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--vocabulary:hover {
        box-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__title,
    .site-content-container .container:has(.page-header__icon--level) .subject-section__title {
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) .subject-section__title {
        border-color: var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-components .subject-character--burned:not(.subject-character--grid) .subject-character__characters,
    .site-content-container .container:has(.page-header__icon--level) #section-components .subject-character--grid.subject-character--burned {
        box-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-components .subject-character--radical:not(.subject-character--grid) .subject-character__characters {
        box-shadow: none;
        background-image: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-section__subtitle,
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-section__text,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-section__subtitle,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-section__text,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-section__subtitle,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-section__text {
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-section__meanings-title,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-section__meanings-title,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-section__meanings-title {
        color: var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-section__meanings,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-section__meanings,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-section__meanings {
        align-items: center;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-section__meanings:first-child p.subject-section__meanings-items,
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-section__meanings:nth-child(2) p.subject-section__meanings-items,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-section__meanings:first-child p.subject-section__meanings-items,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-section__meanings:nth-child(2) p.subject-section__meanings-items,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-section__meanings:first-child p.subject-section__meanings-items,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-section__meanings:nth-child(2) p.subject-section__meanings-items {
        color: var(--USER-text-hl, #c29354);
        font-weight: bold;
        font-size: 1.5rem;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .user-note__link,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .user-note__link,
    .site-content-container .container:has(.page-header__icon--level) #section-context .user-note__link {
        text-shadow: none;
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .user-note__fields,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .user-note__fields,
    .site-content-container .container:has(.page-header__icon--level) #section-context .user-note__fields {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .user-note__fields .user-note__input,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .user-note__fields .user-note__input,
    .site-content-container .container:has(.page-header__icon--level) #section-context .user-note__fields .user-note__input {
        background-color: var(--USER-surface-3, #303030);
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .user-note__fields .user-note__character-count,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .user-note__fields .user-note__character-count,
    .site-content-container .container:has(.page-header__icon--level) #section-context .user-note__fields .user-note__character-count {
        color: var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .user-note__fields .user-note__button,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .user-note__fields .user-note__button,
    .site-content-container .container:has(.page-header__icon--level) #section-context .user-note__fields .user-note__button {
        text-shadow: none;
        color: var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-hint,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-hint,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-hint {
        --color-icon: var(--USER-text-inv, #151515);
        color: var(--USER-text-inv, #151515);
        background-color: var(--USER-surface-inv, #bababa);
        text-shadow: none;
        border-radius: 5px;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-hint .subject-hint__title,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-hint .subject-hint__title,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-hint .subject-hint__title {
        text-shadow: none;
        color: var(--USER-text-inv, #151515);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-readings__reading-title,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-readings__reading-title,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-readings__reading-title {
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-readings__reading-items,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-readings__reading-items,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-readings__reading-items {
        text-shadow: none;
        color: var(--USER-text-hl, #c29354);
        font-weight: bold;
        font-size: 1.5rem;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-readings-with-audio,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-readings-with-audio,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-readings-with-audio {
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-readings-with-audio .reading-with-audio__reading,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-readings-with-audio .reading-with-audio__reading,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-readings-with-audio .reading-with-audio__reading {
        color: var(--USER-text-hl, #c29354);
        font-weight: bold;
        font-size: 2rem;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-collocations__title,
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-collocations,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-collocations__title,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-collocations,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-collocations__title,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-collocations {
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-collocations__patterns::after,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-collocations__patterns::after,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-collocations__patterns::after {
        box-shadow: 0 0 1px var(--USER-text-grayed, #aaaaaa);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-collocations__pattern-name,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-collocations__pattern-name,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-collocations__pattern-name {
        background-color: var(--USER-surface-inv, #bababa);
        color: var(--USER-surface-2, #282828);
        filter: brightness(0.6);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-collocations__pattern-name[aria-selected=true],
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-collocations__pattern-name[aria-selected=true],
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-collocations__pattern-name[aria-selected=true] {
        filter: none;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-meaning .subject-collocations__pattern-name[aria-selected=true]::after,
    .site-content-container .container:has(.page-header__icon--level) #section-reading .subject-collocations__pattern-name[aria-selected=true]::after,
    .site-content-container .container:has(.page-header__icon--level) #section-context .subject-collocations__pattern-name[aria-selected=true]::after {
        background-image: none;
        background-color: var(--USER-surface-2, #282828);
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--level {
        background-color: var(--USER-surface-3, #303030);
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--radical {
        background-color: var(--USER-radical, #56638a);
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--kanji {
        background-color: var(--USER-kanji, #9c4644);
    }
    .site-content-container .container:has(.page-header__icon--level) .page-header__icon--vocabulary {
        background-color: var(--USER-vocab, #58896f);
    }
    .site-content-container .container:has(.page-header__icon--level) #section-amalgamations .subject-character--grid.subject-character--locked {
        background-image: none;
        filter: var(--USER-locked-item-filter, brightness(70%));
    }
    .site-content-container .container:has(.page-header__icon--level) #section-amalgamations .subject-character-grid__item :nth-child(odd) {
        filter: var(--USER-kotoba-odd-row-filter, brightness(0.95));
    }
    .site-content-container .container:has(.page-header__icon--level) #section-amalgamations .subject-character-grid__item:first-child a.subject-character--vocabulary {
        border-radius: 5px 5px 0 0;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-amalgamations .subject-character-grid__item:last-child a.subject-character--vocabulary {
        border-radius: 0 0 5px 5px;
    }
    .site-content-container .container:has(.page-header__icon--level) #section-amalgamations .subject-character--grid.subject-character--burned {
        box-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) .subject-character__badge {
        box-shadow: 0 0 1px var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) .subject-progress {
        text-shadow: none;
    }
    .site-content-container .container:has(.page-header__icon--level) .subject-progress .subject-progress__meta-value {
        color: var(--USER-text-grayed, #aaaaaa);
    }
    .site-content-container .container:has(.page-header__icon--level) .subject-progress .subject-progress__button {
        box-shadow: none;
        background-image: none;
        border-color: var(--USER-surface-3, #303030);
        background-color: var(--USER-surface-3, #303030);
        color: var(--USER-text, #eeeeee);
    }
    .site-content-container .container:has(.page-header__icon--level) .subject-progress .subject-progress__button:hover {
        background-color: var(--USER-surface-2, #282828);
    }
    .site-content-container .container:has(.page-header__icon--level) > :first-child,
    .site-content-container .container:has(.page-header__icon--level) > .subject-pager {
        padding-top: 1.5em;
    }
    .site-content-container .container:has(.page-header__icon--level) > :last-child {
        padding-bottom: 1.5em;
    }

    .subject-character--small-with-meaning .subject-character__characters {
        box-shadow: none;
    }

    #preference_lessons_batch_size,
    #preference_reviews_display_srs_indicator,
    #preference_reviews_presentation_order,
    #preference_lessons_interleave_subjects,
    #preference_preferred_voice_actor_type,
    #preference_lessons_autoplay_audio,
    #preference_reviews_autoplay_audio,
    #preference_extra_study_autoplay_audio,
    #maximum_recommended_daily_lesson_count,
    #username,
    #new_password,
    #current_password,
    #email,
    #new_email_password,
    #preference_timezone,
    #preference_gravatar_profile_pic,
    #preference_opt_mail,
    #preference_emails_on_level_up,
    #preference_update_email_frequency,
    #user_reset_target_level {
        background-color: var(--USER-surface-3, #303030);
    }

    .settings-link,
    #gravatar_profile_pic a:not(.wk-button--default),
    #personal_access_token_frame a:not(.wk-button--default) {
        color: var(--USER-text-hl, #c29354);
    }
    .settings-link:hover,
    #gravatar_profile_pic a:not(.wk-button--default):hover,
    #personal_access_token_frame a:not(.wk-button--default):hover {
        color: var(--USER-text-grayed, #aaaaaa);
    }

    #personal_access_token_frame .wk-code {
        border-radius: 5px;
        padding: 0.3em;
        font-weight: bold;
    }

    .billing-receipts__receipt-link,
    .billing-receipts__receipt-link:visited,
    .billing-receipts__receipt-link:active,
    .billing-receipts__receipt-link:focus,
    .billing-receipts__receipt-link:hover {
        color: var(--USER-text-hl, #c29354);
    }

    .billing-receipts li:nth-child(odd) a {
        filter: var(--USER-kotoba-odd-row-filter, brightness(0.95));
    }

    html:has(.wk-authentication) {
        background-color: var(--USER-surface-1, #151515);
    }
    html:has(.wk-authentication) .wk-authentication a,
    html:has(.wk-authentication) .wk-authentication a:visited {
        color: var(--USER-text-hl, #c29354);
    }
    html:has(.wk-authentication) .wk-authentication a:hover,
    html:has(.wk-authentication) .wk-authentication a:visited:hover {
        color: var(--USER-text-grayed, #aaaaaa);
    }
}